/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.handler.data.IDeal;
import noppes.npcs.api.handler.data.IMarcet;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.DealMarkup;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarcetSection;
import noppes.npcs.controllers.data.MarkupData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class GuiNPCTrader
extends GuiContainerNPCInterface
implements ICustomScrollListener,
IGuiData {
    private static final ResourceLocation BUTTONS = new ResourceLocation("customnpcs", "textures/gui/trader_buttons.png");
    private static boolean isIdSort = true;
    private static boolean isSearch = true;
    private static int section = -1;
    private static Marcet marcet;
    private static final Comparator<TempDeal> comparator;
    private final Map<String, Deal> data = new TreeMap<String, Deal>();
    private int px;
    private int py;
    private int canBuy = 0;
    private int canSell = 0;
    private int ceilPos = -1;
    private int colorP = 0x1000000;
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/trader.png");
    private GuiCustomScroll scroll;
    boolean wait = false;
    private DealMarkup selectDealData;
    private long money = 0L;

    public GuiNPCTrader(EntityNPCInterface npc, ContainerNPCTrader container) {
        super(npc, (Container)container);
        this.field_147000_g = 224;
        this.field_146999_f = 224;
        this.title = "role.trader";
        this.closeOnEsc = true;
        marcet = container.marcet;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() > 4 && button.getID() < 10) {
            section = button.getID() - 5 + this.ceilPos * 5;
            this.func_73866_w_();
            return;
        }
        switch (button.getID()) {
            case 0: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.TraderMarketBuy, marcet.getId(), this.selectDealData.deal.getId(), this.npc.func_145782_y());
                break;
            }
            case 1: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.TraderMarketSell, marcet.getId(), this.selectDealData.deal.getId(), this.npc.func_145782_y());
                break;
            }
            case 2: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.TraderMarketReset, marcet.getId(), this.selectDealData.deal.getId(), this.npc.func_145782_y());
                break;
            }
            case 3: {
                if (this.ceilPos <= 0) {
                    return;
                }
                --this.ceilPos;
                this.func_73866_w_();
                return;
            }
            case 4: {
                if ((double)this.ceilPos >= Math.floor((double)GuiNPCTrader.marcet.sections.size() / 5.0)) {
                    return;
                }
                ++this.ceilPos;
                this.func_73866_w_();
                return;
            }
            case 11: {
                isIdSort = ((GuiNpcCheckBox)button).isSelected();
                this.func_73866_w_();
                return;
            }
            case 12: {
                isSearch = ((GuiNpcCheckBox)button).isSelected();
                this.func_73866_w_();
                return;
            }
        }
        this.wait = true;
        this.func_73866_w_();
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        this.func_146270_b(0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.resource);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(f, i, j);
        if (this.selectDealData != null && !this.selectDealData.main.func_190926_b()) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179091_B();
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            this.func_73729_b(this.px, this.py, 0, 0, 17, 17);
            this.func_73729_b(this.px + 17, this.py, 10, 0, 8, 17);
            this.func_73729_b(this.px, this.py + 17, 0, 10, 17, 8);
            this.func_73729_b(this.px + 17, this.py + 17, 10, 10, 8, 8);
            int redC = -2130771968;
            int orangeC = -2130743808;
            int greenC = -2147418368;
            if (this.colorP != redC && this.selectDealData.deal.getMaxCount() > 0 && this.selectDealData.deal.getAmount() == 0) {
                this.colorP = redC;
            }
            if (this.player.field_71075_bZ.field_75098_d && this.colorP == redC) {
                this.colorP = orangeC;
            }
            Gui.func_73734_a((int)(this.px + 1), (int)(this.py + 1), (int)(this.px + 24), (int)(this.py + 24), (int)this.colorP);
            GlStateManager.func_179101_C();
            if (this.getLabel(4) != null && this.getLabel(4).isEnabled()) {
                if (this.money != ClientProxy.playerData.game.getMoney()) {
                    this.money = ClientProxy.playerData.game.getMoney();
                    if (this.selectDealData.buyMoney > 0L) {
                        String text = Util.instance.getTextReducedNumber(this.selectDealData.buyMoney, true, true, false) + CustomNpcs.displayCurrencies + " / " + ClientProxy.playerData.game.getTextMoney() + CustomNpcs.displayCurrencies;
                        if (GuiNPCTrader.marcet.isLimited) {
                            text = text + " / " + Util.instance.getTextReducedNumber(GuiNPCTrader.marcet.money, true, true, false) + CustomNpcs.displayCurrencies;
                        }
                        this.getLabel(4).setLabel(text);
                    }
                }
                if (this.getButton(0) != null && this.getButton(0).isHovered()) {
                    int color;
                    int n = color = this.player.field_71075_bZ.field_75098_d ? orangeC : redC;
                    if (this.money >= (long)this.selectDealData.deal.getMoney()) {
                        color = greenC;
                    }
                    Gui.func_73734_a((int)(this.px - 2), (int)(this.field_147009_r + 112), (int)(this.field_147003_i + 218), (int)(this.field_147009_r + 136), (int)color);
                }
            }
            if (!this.selectDealData.buyHasPlayerItems.isEmpty()) {
                GlStateManager.func_179094_E();
                this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
                int slot = 0;
                for (ItemStack curr : this.selectDealData.buyHasPlayerItems.keySet()) {
                    int u = this.px + slot % 3 * 18;
                    int v = this.py + 38 + slot / 3 * 18;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(u, v, 0, 0, 18, 18);
                    if (this.getButton(0) != null && this.getButton(0).isHovered()) {
                        Gui.func_73734_a((int)(u + 1), (int)(v + 1), (int)(u + 17), (int)(v + 17), (int)(this.selectDealData.buyHasPlayerItems.get(curr) != false ? greenC : (this.player.field_71075_bZ.field_75098_d ? orangeC : redC)));
                    }
                    ++slot;
                }
                GlStateManager.func_179121_F();
            }
        }
        if (GuiNPCTrader.marcet.showXP) {
            this.field_146297_k.func_110434_K().func_110577_a(this.resource);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 139, 234, 0, 22, 76);
            MarkupData md = ClientProxy.playerData.game.getMarkupData(marcet.getId());
            double plXP = md.xp;
            double mXP = GuiNPCTrader.marcet.markup.get((Object)Integer.valueOf((int)md.level)).xp;
            if (plXP > mXP) {
                plXP = mXP;
            }
            double h = 74.0 * plXP / mXP;
            int g = (int)h;
            boolean t = false;
            if (h > 0.0 && h < 74.0) {
                --g;
                t = true;
            }
            if (g > 0) {
                this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 214 - g, 235, 151 - g, 20, g);
            }
            if (t) {
                GlStateManager.func_179131_c((float)0.85f, (float)0.85f, (float)0.85f, (float)1.0f);
                if (g == 0) {
                    g = 1;
                }
                this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 213 - g, 236, 151 - g, 20, 1);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            String lv = Util.instance.deleteColor(new TextComponentTranslation("enchantment.level." + md.level, new Object[0]).func_150254_d());
            if (lv.equals("enchantment.level." + md.level)) {
                lv = "" + md.level;
            }
            this.field_146297_k.field_71466_p.func_175065_a(lv, (float)(this.field_147003_i + 16) - (float)this.field_146297_k.field_71466_p.func_78256_a(lv) / 2.0f, (float)(this.field_147009_r + 205), CustomNpcs.MainColor.getRGB(), true);
        }
        if (this.subgui != null) {
            return;
        }
        int u0 = this.px - 2;
        int u1 = this.field_147003_i + this.field_146999_f - 7;
        int backC = -1610612736;
        this.func_73730_a(u0, u1, this.field_147009_r + 14, backC);
        this.func_73728_b(u0 - 1, this.field_147009_r + 14, this.field_147009_r + 43, backC);
        this.func_73728_b(u1 + 1, this.field_147009_r + 14, this.field_147009_r + 43, backC);
        this.func_73730_a(u0, u1, this.field_147009_r + 43, backC);
        if (this.selectDealData != null && !this.selectDealData.baseItems.isEmpty()) {
            this.func_73728_b(u0 - 1, this.field_147009_r + 43, this.field_147009_r + 111, backC);
            this.func_73728_b(u1 + 1, this.field_147009_r + 43, this.field_147009_r + 111, backC);
        }
        if (!(this.selectDealData == null || this.selectDealData.baseItems.isEmpty() && this.selectDealData.baseMoney <= 0L)) {
            this.func_73730_a(u0, u1, this.field_147009_r + 111, backC);
        }
        if (this.selectDealData != null && this.selectDealData.baseMoney > 0L) {
            this.func_73730_a(u0, u1, this.field_147009_r + 136, backC);
            this.func_73728_b(u0 - 1, this.field_147009_r + 111, this.field_147009_r + 136, backC);
            this.func_73728_b(u1 + 1, this.field_147009_r + 111, this.field_147009_r + 136, backC);
        }
        this.colorP = 0x1000000;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = ItemStack.field_190927_a;
        int ct = 0;
        if (this.selectDealData != null && !this.selectDealData.main.func_190926_b()) {
            stack = this.selectDealData.main;
            ct = this.selectDealData.count;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)50.0f);
            GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(this.px - this.field_147003_i), (float)(this.py - this.field_147009_r), (float)0.0f);
            RenderHelper.func_74520_c();
            float s = 1.5f;
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            this.field_146297_k.func_175599_af().func_180450_b(this.selectDealData.main, 0, 0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.func_73731_b(this.field_146297_k.field_71466_p, "" + this.selectDealData.count, 16 - this.field_146297_k.field_71466_p.func_78256_a("" + this.selectDealData.count), 9, -1);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            if (this.isMouseHover(mouseX, mouseY, this.px, this.field_147009_r + 14, 25, 25)) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(new TextComponentTranslation("market.hover.product", new Object[0]).func_150254_d());
                list.addAll(this.selectDealData.main.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
                this.setHoverText(list);
            }
            if (!this.selectDealData.buyItems.isEmpty()) {
                int slot = 0;
                for (ItemStack curr : this.selectDealData.buyItems.keySet()) {
                    int u = this.px + 1 + slot % 3 * 18;
                    int v = this.py + 39 + slot / 3 * 18;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)u, (float)v, (float)50.0f);
                    this.field_146297_k.func_175599_af().func_180450_b(curr, 0, 0);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                    int count = this.selectDealData.buyItems.get(curr);
                    this.func_73731_b(this.field_146297_k.field_71466_p, "" + count, 16 - this.field_146297_k.field_71466_p.func_78256_a("" + count), 9, -1);
                    GlStateManager.func_179121_F();
                    if (this.isMouseHover(mouseX, mouseY, u, v, 18, 18)) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(new TextComponentTranslation("market.hover.item", new Object[0]).func_150254_d());
                        list.addAll(curr.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
                        this.setHoverText(list);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(u, v, 0, 0, 18, 18);
                    ++slot;
                }
            }
        }
        if (this.getLabel(6) != null && this.getLabel(6).isEnabled()) {
            this.getLabel(6).setLabel(new TextComponentTranslation("market.uptime", new Object[]{Util.instance.ticksToElapsedTime(GuiNPCTrader.marcet.nextTime / 50L, false, false, false)}).func_150254_d());
            if (GuiNPCTrader.marcet.nextTime <= 0L) {
                NoppesUtilPlayer.sendDataCheckDelay(EnumPlayerPacket.MarketTime, this, 2500L, marcet.getId());
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.subgui != null) {
            return;
        }
        if (this.getLabel(3) != null && this.getLabel(3).isEnabled() && this.isMouseHover(mouseX, mouseY, this.px - 2, this.field_147009_r + 113, 80, 24)) {
            int buyMoney = this.selectDealData.deal.getMoney();
            if (this.selectDealData != null && this.selectDealData.buyMoney > 0L) {
                buyMoney = (int)this.selectDealData.buyMoney;
            }
            TextComponentTranslation text = new TextComponentTranslation("market.hover.currency.0", new Object[]{"" + buyMoney, CustomNpcs.displayCurrencies, "" + this.money, CustomNpcs.displayCurrencies});
            if (GuiNPCTrader.marcet.isLimited) {
                text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.currency.1", new Object[]{"" + GuiNPCTrader.marcet.money}));
            }
            this.setHoverText(text.func_150254_d(), new Object[0]);
        } else if (this.getButton(0) != null && this.getButton(0).isVisible() && this.getButton(0).isHovered()) {
            TextComponentTranslation text = new TextComponentTranslation("market.hover.buy", new Object[]{stack.func_82833_r()});
            if (this.canBuy != 0) {
                text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.notbuy." + this.canBuy, new Object[0]));
            }
            this.setHoverText(text.func_150254_d(), new Object[0]);
        } else if (this.getButton(1) != null && this.getButton(1).isVisible() && this.getButton(1).isHovered()) {
            this.colorP = -2147418368;
            if (Util.instance.inventoryItemCount((EntityPlayer)this.player, stack, this.selectDealData.deal.availability, this.selectDealData.deal.getIgnoreDamage(), this.selectDealData.deal.getIgnoreNBT()) < ct) {
                this.colorP = -2130771968;
            }
            TextComponentTranslation text = new TextComponentTranslation("market.hover.sell.0", new Object[]{stack.func_82833_r()});
            if (this.canSell != 0) {
                text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.notsell." + this.canSell, new Object[0]));
            } else {
                if (this.selectDealData != null && !this.selectDealData.sellHasPlayerItems.isEmpty()) {
                    if (!this.selectDealData.sellItems.isEmpty()) {
                        if (this.selectDealData.sellOneOfEach) {
                            text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.sell.3", new Object[0]));
                        } else {
                            text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.sell.1", new Object[0]));
                        }
                    }
                    for (ItemStack s : this.selectDealData.sellItems.keySet()) {
                        text.func_150257_a((ITextComponent)new TextComponentString("<br>" + s.func_82833_r() + (this.selectDealData.sellOneOfEach ? "" : " x" + this.selectDealData.sellItems.get(s))));
                    }
                }
                if (this.selectDealData != null && this.selectDealData.sellMoney > 0L) {
                    text.func_150257_a((ITextComponent)new TextComponentTranslation("market.hover.sell.2", new Object[]{"" + this.selectDealData.sellMoney, CustomNpcs.displayCurrencies}));
                }
            }
            this.setHoverText(text.func_150254_d(), new Object[0]);
        }
        if (GuiNPCTrader.marcet.showXP && this.isMouseHover(mouseX, mouseY, this.field_147003_i + 7, this.field_147009_r + 140, 22, 74)) {
            MarkupData md = ClientProxy.playerData.game.getMarkupData(marcet.getId());
            MarkupData mm = GuiNPCTrader.marcet.markup.get(md.level);
            int pXP = Math.min(md.xp, mm.xp);
            this.setHoverText("market.hover.you.level", "" + (md.level + 1), "" + pXP, "" + mm.xp, "" + (int)(mm.buy * 100.0f), "" + (int)(mm.sell * 100.0f));
        } else if (this.getButton(2) != null && this.getButton(2).isVisible() && this.getButton(2).isHovered()) {
            this.setHoverText(new TextComponentTranslation("market.hover.reset", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.selectDealData.deal != null && this.selectDealData.deal.getMaxCount() > 0 && this.isMouseHover(mouseX, mouseY, this.field_147003_i + 177, this.field_147009_r + 24, 45, 14)) {
            this.setHoverText(this.selectDealData.deal.getMaxCount() > 0 ? new TextComponentTranslation("market.hover.item.amount", new Object[]{"" + this.selectDealData.deal.getAmount()}).func_150254_d() : "", new Object[0]);
        } else if (this.getLabel(6) != null && this.getLabel(6).isEnabled() && this.getLabel(6).isHovered()) {
            this.setHoverText(new TextComponentTranslation("market.hover.update", new Object[0]).func_150254_d(), new Object[0]);
        }
        this.drawHoverText(null, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.data.clear();
        this.px = this.field_147003_i + 162;
        this.py = this.field_147009_r + 17;
        if (this.ceilPos < 0) {
            this.ceilPos = 0;
            section = 0;
        }
        if (GuiNPCTrader.marcet.sections.size() > 1) {
            GuiMenuSideButton tab;
            if (GuiNPCTrader.marcet.sections.size() > 5) {
                if (this.ceilPos > 0) {
                    tab = new GuiMenuSideButton(3, this.field_147003_i + 1, this.field_147009_r + 4, "\u02c4");
                    tab.field_146121_g = 16;
                    tab.offsetText = 1;
                    this.addButton(tab);
                }
                if ((double)this.ceilPos < Math.floor((double)GuiNPCTrader.marcet.sections.size() / 5.0)) {
                    tab = new GuiMenuSideButton(4, this.field_147003_i + 1, this.field_147009_r + 100, "\u02c5");
                    tab.field_146121_g = 16;
                    tab.offsetText = 2;
                    this.addButton(tab);
                }
            }
            for (int i = 0; i < 5 && i + this.ceilPos * 5 < GuiNPCTrader.marcet.sections.size(); ++i) {
                tab = new GuiMenuSideButton(5 + i, this.field_147003_i + 1, this.field_147009_r + 20 + i * 16, GuiNPCTrader.marcet.sections.get(i + this.ceilPos * 5).getName());
                tab.data = i + this.ceilPos * 5;
                tab.field_146121_g = 16;
                if (i + this.ceilPos * 5 == section) {
                    tab.active = true;
                }
                this.addButton(tab);
            }
        }
        ArrayList<TempDeal> selectInTrade = new ArrayList<TempDeal>();
        ArrayList<TempDeal> selectNotTrade = new ArrayList<TempDeal>();
        int level = ClientProxy.playerData.game.getMarcetLevel(marcet.getId());
        MarcetController mData = MarcetController.getInstance();
        MarcetSection ms = GuiNPCTrader.marcet.sections.get(section);
        if (ms != null && !ms.deals.isEmpty()) {
            for (Deal deal : ms.deals) {
                String key = deal.getName();
                while (this.data.containsKey(key)) {
                    key = "\u00a7r" + key;
                }
                if (deal.getMaxCount() != 0 && deal.getAmount() == 0) {
                    selectNotTrade.add(new TempDeal(deal.getId(), deal.getProduct().getDisplayName(), key));
                } else {
                    selectInTrade.add(new TempDeal(deal.getId(), deal.getProduct().getDisplayName(), key));
                }
                this.data.put(key, deal);
                if (this.selectDealData == null || this.selectDealData.deal == null || this.selectDealData.deal.getId() != deal.getId()) continue;
                this.selectDealData = mData.getBuyData(marcet, deal, level);
            }
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 6);
            this.scroll.setSize(154, 123);
        }
        selectInTrade.sort(comparator);
        selectNotTrade.sort(comparator);
        ArrayList<String> sel = new ArrayList<String>();
        for (TempDeal td : selectInTrade) {
            sel.add(td.key);
        }
        for (TempDeal td : selectNotTrade) {
            sel.add(td.key);
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ArrayList<String> suffixes = new ArrayList<String>();
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String key : sel) {
            Deal deal = this.data.get(key);
            DealMarkup dm = mData.getBuyData(marcet, deal, level);
            arrayList.add(dm.main);
            ArrayList<String> info = new ArrayList<String>();
            info.add(new TextComponentTranslation("market.hover.product", new Object[0]).func_150254_d());
            if (deal.getMaxCount() > 0) {
                suffixes.add('\u00a7' + (deal.getAmount() == 0 ? "4" : (deal.getAmount() < deal.getProduct().getMaxStackSize() ? "b" : "a")) + Util.instance.getTextReducedNumber(deal.getAmount(), true, true, false));
            } else {
                suffixes.add("\u00a7a" + new String(Character.toChars(8734)));
            }
            info.add(dm.main.func_82833_r() + " x" + dm.count + " " + new TextComponentTranslation("market.hover.item." + (deal.getMaxCount() > 0 ? (deal.getAmount() == 0 ? "not" : "amount") : "infinitely"), new Object[]{"" + deal.getAmount()}).func_150254_d());
            if (!dm.buyItems.isEmpty()) {
                info.add(new TextComponentTranslation("market.hover.item", new Object[0]).func_150254_d());
                for (ItemStack curr : dm.buyItems.keySet()) {
                    info.add(curr.func_82833_r() + " x" + dm.buyItems.get(curr));
                }
            }
            if (dm.buyMoney > 0L) {
                info.add(new TextComponentTranslation("market.hover.currency", new Object[0]).func_150254_d());
                info.add(dm.buyMoney + CustomNpcs.displayCurrencies);
            }
            hts.put(i++, info);
        }
        if (this.selectDealData == null || this.selectDealData.deal == null) {
            this.selectDealData = mData.getBuyData(marcet, this.data.get(sel.get(0)), level);
        }
        this.selectDealData.check((NonNullList<ItemStack>)this.field_146297_k.field_71439_g.field_71071_by.field_70462_a);
        this.scroll.canSearch(isSearch);
        this.scroll.setListNotSorted(sel);
        this.scroll.setStacks(arrayList);
        this.scroll.setHoverTexts(hts);
        this.scroll.setSuffixes(suffixes);
        this.scroll.guiLeft = this.field_147003_i + 4;
        this.scroll.guiTop = this.field_147009_r + 14;
        this.scroll.setSelected(this.selectDealData.deal.getName());
        this.title = marcet.getShowName();
        this.addScroll(this.scroll);
        int gray = -14671840;
        this.addLabel(new GuiNpcLabel(1, "market.deals", this.field_147003_i + 4, this.field_147009_r + 5));
        GuiNpcLabel label = new GuiNpcLabel(2, "market.barter", this.px, this.field_147009_r + 46);
        label.color = gray;
        label.enabled = !this.selectDealData.buyItems.isEmpty();
        this.addLabel(label);
        this.addLabel(new GuiNpcLabel(3, "market.currency", this.px, this.field_147009_r + 114, gray));
        this.addLabel(new GuiNpcLabel(4, "", this.px, this.field_147009_r + 126, gray));
        this.money = ClientProxy.playerData.game.getMoney();
        if (this.selectDealData.buyMoney > 0L) {
            this.getLabel(3).setEnabled(true);
            String text = Util.instance.getTextReducedNumber(this.selectDealData.buyMoney, true, true, false) + CustomNpcs.displayCurrencies + " / " + ClientProxy.playerData.game.getTextMoney() + CustomNpcs.displayCurrencies;
            if (GuiNPCTrader.marcet.isLimited) {
                text = text + " / " + Util.instance.getTextReducedNumber(GuiNPCTrader.marcet.money, true, true, false) + CustomNpcs.displayCurrencies;
            }
            this.getLabel(4).setEnabled(true);
            this.getLabel(4).setLabel(text);
        } else {
            this.getLabel(3).setEnabled(false);
            this.getLabel(4).setEnabled(false);
        }
        this.addLabel(new GuiNpcLabel(5, "", this.px + 27, this.field_147009_r + 25, gray));
        if (this.selectDealData.deal.getMaxCount() > 0) {
            this.getLabel(5).setLabel('\u00a7' + (this.selectDealData.deal.getAmount() == 0 ? "4" : (this.selectDealData.deal.getAmount() < this.selectDealData.deal.getProduct().getMaxStackSize() ? "1" : "2")) + "x" + Util.instance.getTextReducedNumber(this.selectDealData.deal.getAmount(), true, true, false));
        } else {
            this.getLabel(5).setLabel(new String(Character.toChars(8734)));
        }
        if (GuiNPCTrader.marcet.updateTime > 0) {
            this.addLabel(new GuiNpcLabel(6, "", this.field_147003_i + 80, this.field_147009_r + 5, gray));
            this.getLabel(6).setEnabled(GuiNPCTrader.marcet.updateTime > 0);
        }
        int x = this.field_147003_i + 194;
        int y = this.field_147009_r + 139;
        GuiNpcButton button = new GuiNpcButton(0, x, y, 12, 18, 0, 0, BUTTONS);
        this.addButton(button);
        button.txrW = 24;
        button.txrH = 36;
        button.setIsAnim(true);
        button.setIsVisible(this.selectDealData.deal.getType() != 1);
        this.canBuy = 0;
        if (button.isVisible()) {
            if (!this.player.field_71075_bZ.field_75098_d) {
                if (this.wait || this.selectDealData.deal.getType() == 1) {
                    this.canBuy = 1;
                }
                if (this.canBuy == 0 && this.selectDealData.deal.getAmount() <= 0) {
                    this.canBuy = 6;
                }
                if (this.canBuy == 0 && !this.selectDealData.deal.availability.isAvailable((EntityPlayer)this.player)) {
                    this.canBuy = 2;
                }
                if (this.canBuy == 0 && this.selectDealData.buyMoney > 0L && this.money < this.selectDealData.buyMoney) {
                    this.canBuy = 3;
                }
                if (this.canBuy == 0 && !Util.instance.canRemoveItems((NonNullList<ItemStack>)this.player.field_71071_by.field_70462_a, this.selectDealData.buyItems, this.selectDealData.ignoreDamage, this.selectDealData.ignoreNBT)) {
                    this.canBuy = 4;
                }
                if (this.canBuy == 0 && !Util.instance.canAddItemAfterRemoveItems((NonNullList<ItemStack>)this.player.field_71071_by.field_70462_a, this.selectDealData.main, this.selectDealData.buyItems, this.selectDealData.ignoreDamage, this.selectDealData.ignoreNBT)) {
                    this.canBuy = 5;
                }
            }
            button.setEnabled(this.canBuy == 0);
        }
        button = new GuiNpcButton(1, x + 13, y, 12, 18, 24, 0, BUTTONS);
        this.addButton(button);
        button.txrW = 24;
        button.txrH = 36;
        button.setIsAnim(true);
        button.setIsVisible(this.selectDealData.deal.getType() != 0);
        this.canSell = 0;
        if (button.isVisible()) {
            if (!this.player.field_71075_bZ.field_75098_d) {
                if (this.wait) {
                    this.canSell = 1;
                } else if (!this.selectDealData.deal.availability.isAvailable((EntityPlayer)this.player)) {
                    this.canSell = 2;
                } else {
                    HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
                    map.put(this.selectDealData.main, this.selectDealData.count);
                    if (this.canSell == 0 && !this.selectDealData.main.func_190926_b() && !Util.instance.canRemoveItems((NonNullList<ItemStack>)this.player.field_71071_by.field_70462_a, map, this.selectDealData.ignoreDamage, this.selectDealData.ignoreNBT)) {
                        this.canSell = 3;
                    }
                    if (this.canSell == 0 && GuiNPCTrader.marcet.isLimited) {
                        if (this.selectDealData.sellMoney > GuiNPCTrader.marcet.money) {
                            this.canSell = 4;
                        }
                        if (this.canSell == 0 && !this.selectDealData.sellItems.isEmpty() && !Util.instance.canRemoveItems(GuiNPCTrader.marcet.inventory, this.selectDealData.sellItems, this.selectDealData.ignoreDamage, this.selectDealData.ignoreNBT)) {
                            this.canSell = 5;
                        }
                    }
                    if (this.canSell == 0 && this.selectDealData.deal.getMaxCount() == 0 && this.canBuy == 6 && this.selectDealData.deal.getType() != 1) {
                        this.canSell = 6;
                    }
                }
            }
            button.setEnabled(this.canSell == 0);
        }
        this.addButton(new GuiNpcButton(2, this.field_147003_i - 66, this.field_147009_r + 117, 64, 20, "remote.reset"));
        this.getButton(2).setIsVisible(this.player.field_71075_bZ.field_75098_d);
        button = new GuiNpcCheckBox(11, x, y += 20, 26, 12, "type.id", "N", isIdSort);
        this.addButton(button);
        button.setHoverText("hover.sort", new TextComponentTranslation("market.deals", new Object[0]).func_150254_d(), new TextComponentTranslation(isIdSort ? "type.id" : "gui.name", new Object[0]).func_150254_d());
        if (sel.size() > 9) {
            button = new GuiNpcCheckBox(12, x, y + 18, 26, 12, "+", "-", isSearch);
            this.addButton(button);
            button.setHoverText("market.hover.is.search", new Object[0]);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 200 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == 208 || i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            int pos = this.scroll.getSelect() + (i == 200 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() ? -1 : 1);
            if (pos < 0 || pos >= this.scroll.getList().size()) {
                return;
            }
            String sel = this.scroll.getList().get(pos);
            if (!this.data.containsKey(sel)) {
                return;
            }
            this.selectDealData.deal = this.data.get(sel);
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.TraderMarketRemove, marcet.getId());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!this.data.containsKey(scroll.getSelected())) {
            return;
        }
        this.selectDealData.deal = this.data.get(scroll.getSelected());
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        IMarcet market = MarcetController.getInstance().getMarcet(marcet.getId());
        this.wait = false;
        marcet = (Marcet)market;
        ((ContainerNPCTrader)this.field_147002_h).marcet = (Marcet)market;
        this.func_73866_w_();
    }

    static {
        comparator = (t1, t2) -> {
            if (isIdSort) {
                HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                int i = 0;
                for (IDeal iDeal : marcet.getDeals(section)) {
                    indexMap.put(iDeal.getId(), i++);
                }
                return Integer.compare(indexMap.getOrDefault(t1.id, Integer.MAX_VALUE), indexMap.getOrDefault(t2.id, Integer.MAX_VALUE));
            }
            return t1.stackName.compareToIgnoreCase(t2.stackName);
        };
    }

    public static class TempDeal {
        public final int id;
        public final String stackName;
        public final String key;

        public TempDeal(int id, String stackName, String key) {
            this.id = id;
            this.stackName = stackName;
            this.key = key;
        }
    }
}

